﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using UnityEngine;

public class TimeTrialDifficultyConfiguration : ConfigurationElement
{
    public int MoneyLowerRange { get; private set; }
    public int MoneyUpperRange { get; private set; }

    public TimeTrialDifficultyConfiguration(string id) : base(id)
    {

    }

    public override bool Parse(XElement configElem)
    {
        try
        {
            MoneyLowerRange = Convert.ToInt32(configElem.Element("MoneyLowerRange").Value);
            MoneyUpperRange = Convert.ToInt32(configElem.Element("MoneyUpperRange").Value);
            return true;
        }

        catch (Exception ex)
        {
            Debug.LogError("ERROR: Caught an exception when parsing time trial difficulty configuration. The exception is: " + ex);
            Preloader.ExceptionMessage = ex.ToString();
            return false;
        }
    }
}
